/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp2;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import cz.insophy.inplan.mrp2.PropertyTransferer;
import cz.insophy.inplan.mrp2.SortKeyExtractor;
import cz.insophy.inplan.mrp2.Supply;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import java.util.List;
import javax.annotation.Nonnull;

public class GorSupply
implements Supply {
    private final GeneralizedOrderRequest gor;
    private final double qty;

    public GorSupply(@Nonnull GeneralizedOrderRequest gor, double qty) {
        Preconditions.checkArgument(qty > 0.0);
        this.gor = Preconditions.checkNotNull(gor);
        this.qty = qty;
    }

    @Nonnull
    public GeneralizedOrderRequest getGor() {
        return this.gor;
    }

    @Override
    @Nonnull
    public Material getMaterial() {
        return this.gor.getProduct();
    }

    @Override
    public double getQty() {
        return this.qty;
    }

    @Override
    @Nonnull
    public <T extends Comparable<T>> T getSortKey(@Nonnull SortKeyExtractor<T> sortKeyExtractor) {
        return sortKeyExtractor.extract(this);
    }

    @Override
    public <T> void apply(@Nonnull PropertyTransferer<T> propertyTransferer, @Nonnull List<T> demandsProps) {
        propertyTransferer.setProperties(this.gor, demandsProps);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("gor", this.gor).add("qty", this.qty).toString();
    }
}

